﻿/*
	VERSION:		1.4
	
	PURPOSE:
		This runs blocks of code in sequence, as a chain-reaction.
		allowing for arbitrary delays and halts.
		This is simple but very powerful.
		
	USAGE:
		#include "scriptSystem.as"
		events = makeScriptSystem(my_mc);
		
		events.push(function(){		trace("First event!");		events.nextEvent();		  });
		events.push(function(){		trace("Second event!");		  });
		
		events.runEvent(0);
		
	NOTE:
		A standard set of event functions can be defined,
		which makes this easier to use this,
		because they automatically call nextEvent() afterwords.
		example:
			events.push(		talk( events, "Hello World!");		);
		A reference to the script system is passed to them,
		allowing them to resume the script when they're done.
		
	FUNCTIONS:
		done()		externally-defined function that's called when the script reaches its end.
		
	PROPERTIES:
		isDone		Indicates whether the script has already finished running.
*/
makeScriptSystem = function( sprite )
{
	// resolve optional parameters
	var sprite = (sprite) ? sprite : this;
	
	// create container
	var _this = new Array();
	
	// variables
	_this.index = 0;				// current event
	_this.sprite = sprite;		// convenient reference to the sprite that calls the script.
	
	
	
	// ______________________________________________________________________________________________________
	// FUNCTIONS
	_this.runEvent = function( eventIndex )
	{
		var eventIndex = (eventIndex!=undefined) ? eventIndex : 0;		// If the event isn't specified, start at the beginning.
		_this.index = eventIndex;		// continue running events from this point
		_this[eventIndex].call();
		
		if(eventIndex == _this.length-1)
		{// if:  The last event was just called
			_this.isDone = true;		// script IS done
			_this.done();				// externally-defined  (used for:  wait for movement)
			delete _this.done;
		}else{
			_this.isDone = false;		// script isn't done
		}
	}// runEvent()
	
	
	
	_this.nextEvent = function()
	{
		_this.index++
		_this.runEvent(_this.index);
	}// nextEvent()
	
	
	
	// This enables scripts be be defined using array shorthand  []
	_this.defineScript = function( elements )	{
		for( var i=0; i<elements.length; i++)	{
			_this[i] = elements[i];
		}// for:  each element
	}// defineScript()
	// ______________________________________________________________________________________________________
	
	
	
	// return container
	return _this;
}// makeScriptSystem()